/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class LogConfigurationJsonMarshaller {
    private static LogConfigurationJsonMarshaller instance;

    public void marshall(LogConfiguration logConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (logConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> optionsMap;
            jsonGenerator.writeStartObject();
            if (logConfiguration.getLogDriver() != null) {
                jsonGenerator.writeFieldName("logDriver").writeValue(logConfiguration.getLogDriver());
            }
            if ((optionsMap = logConfiguration.getOptions()) != null) {
                jsonGenerator.writeFieldName("options");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> optionsMapValue : optionsMap.entrySet()) {
                    if (optionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(optionsMapValue.getKey());
                    jsonGenerator.writeValue(optionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LogConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LogConfigurationJsonMarshaller();
        }
        return instance;
    }
}

