/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListStreamsRequestMarshaller
implements Marshaller<Request<ListStreamsRequest>, ListStreamsRequest> {
    @Override
    public Request<ListStreamsRequest> marshall(ListStreamsRequest listStreamsRequest) {
        if (listStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStreamsRequest> request = new DefaultRequest<ListStreamsRequest>(listStreamsRequest, "AmazonDynamoDBStreams");
        request.addHeader("X-Amz-Target", "DynamoDBStreams_20120810.ListStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.0");
            jsonGenerator.writeStartObject();
            if (listStreamsRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(listStreamsRequest.getTableName());
            }
            if (listStreamsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listStreamsRequest.getLimit());
            }
            if (listStreamsRequest.getExclusiveStartStreamArn() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartStreamArn").writeValue(listStreamsRequest.getExclusiveStartStreamArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

