/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.config.model.ResourceIdentifier;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ResourceIdentifierJsonMarshaller {
    private static ResourceIdentifierJsonMarshaller instance;

    public void marshall(ResourceIdentifier resourceIdentifier, StructuredJsonGenerator jsonGenerator) {
        if (resourceIdentifier == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (resourceIdentifier.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(resourceIdentifier.getResourceType());
            }
            if (resourceIdentifier.getResourceId() != null) {
                jsonGenerator.writeFieldName("resourceId").writeValue(resourceIdentifier.getResourceId());
            }
            if (resourceIdentifier.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(resourceIdentifier.getResourceName());
            }
            if (resourceIdentifier.getResourceDeletionTime() != null) {
                jsonGenerator.writeFieldName("resourceDeletionTime").writeValue(resourceIdentifier.getResourceDeletionTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceIdentifierJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceIdentifierJsonMarshaller();
        }
        return instance;
    }
}

