/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class EnableStageTransitionRequestMarshaller
implements Marshaller<Request<EnableStageTransitionRequest>, EnableStageTransitionRequest> {
    @Override
    public Request<EnableStageTransitionRequest> marshall(EnableStageTransitionRequest enableStageTransitionRequest) {
        if (enableStageTransitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableStageTransitionRequest> request = new DefaultRequest<EnableStageTransitionRequest>(enableStageTransitionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.EnableStageTransition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (enableStageTransitionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(enableStageTransitionRequest.getPipelineName());
            }
            if (enableStageTransitionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(enableStageTransitionRequest.getStageName());
            }
            if (enableStageTransitionRequest.getTransitionType() != null) {
                jsonGenerator.writeFieldName("transitionType").writeValue(enableStageTransitionRequest.getTransitionType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

