/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class GetConfigRequestMarshaller
implements Marshaller<Request<GetConfigRequest>, GetConfigRequest> {
    @Override
    public Request<GetConfigRequest> marshall(GetConfigRequest getConfigRequest) {
        if (getConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetConfigRequest> request = new DefaultRequest<GetConfigRequest>(getConfigRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.GetConfig");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList hapgListList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (getConfigRequest.getClientArn() != null) {
                jsonGenerator.writeFieldName("ClientArn").writeValue(getConfigRequest.getClientArn());
            }
            if (getConfigRequest.getClientVersion() != null) {
                jsonGenerator.writeFieldName("ClientVersion").writeValue(getConfigRequest.getClientVersion());
            }
            if (!(hapgListList = (SdkInternalList)getConfigRequest.getHapgList()).isEmpty() || !hapgListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("HapgList");
                jsonGenerator.writeStartArray();
                for (String hapgListListValue : hapgListList) {
                    if (hapgListListValue == null) continue;
                    jsonGenerator.writeValue(hapgListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

