/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Method;
import com.amazonaws.services.apigateway.model.Resource;
import com.amazonaws.services.apigateway.model.transform.MethodJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, StructuredJsonGenerator jsonGenerator) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Method> resourceMethodsMap;
            jsonGenerator.writeStartObject();
            if (resource.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(resource.getId());
            }
            if (resource.getParentId() != null) {
                jsonGenerator.writeFieldName("parentId").writeValue(resource.getParentId());
            }
            if (resource.getPathPart() != null) {
                jsonGenerator.writeFieldName("pathPart").writeValue(resource.getPathPart());
            }
            if (resource.getPath() != null) {
                jsonGenerator.writeFieldName("path").writeValue(resource.getPath());
            }
            if ((resourceMethodsMap = resource.getResourceMethods()) != null) {
                jsonGenerator.writeFieldName("resourceMethods");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Method> resourceMethodsMapValue : resourceMethodsMap.entrySet()) {
                    if (resourceMethodsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(resourceMethodsMapValue.getKey());
                    MethodJsonMarshaller.getInstance().marshall(resourceMethodsMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

