/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetModelsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetModelsRequestMarshaller
implements Marshaller<Request<GetModelsRequest>, GetModelsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetModelsRequest> marshall(GetModelsRequest getModelsRequest) {
        if (getModelsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetModelsRequest> request = new DefaultRequest<GetModelsRequest>(getModelsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelsRequest.getRestApiId() != null ? StringUtils.fromString(getModelsRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getModelsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getModelsRequest.getPosition()));
        }
        if (getModelsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getModelsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

