/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GenerateClientCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class GenerateClientCertificateRequestMarshaller
implements Marshaller<Request<GenerateClientCertificateRequest>, GenerateClientCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GenerateClientCertificateRequest> marshall(GenerateClientCertificateRequest generateClientCertificateRequest) {
        if (generateClientCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateClientCertificateRequest> request = new DefaultRequest<GenerateClientCertificateRequest>(generateClientCertificateRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/clientcertificates";
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (generateClientCertificateRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(generateClientCertificateRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

