/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.DomainSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDomainsResult
implements Serializable,
Cloneable {
    private SdkInternalList<DomainSummary> domains;
    private String nextPageMarker;

    public List<DomainSummary> getDomains() {
        if (this.domains == null) {
            this.domains = new SdkInternalList();
        }
        return this.domains;
    }

    public void setDomains(Collection<DomainSummary> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        this.domains = new SdkInternalList<DomainSummary>(domains);
    }

    public ListDomainsResult withDomains(DomainSummary ... domains) {
        if (this.domains == null) {
            this.setDomains(new SdkInternalList<DomainSummary>(domains.length));
        }
        for (DomainSummary ele : domains) {
            this.domains.add(ele);
        }
        return this;
    }

    public ListDomainsResult withDomains(Collection<DomainSummary> domains) {
        this.setDomains(domains);
        return this;
    }

    public void setNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
    }

    public String getNextPageMarker() {
        return this.nextPageMarker;
    }

    public ListDomainsResult withNextPageMarker(String nextPageMarker) {
        this.setNextPageMarker(nextPageMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomains() != null) {
            sb.append("Domains: " + this.getDomains() + ",");
        }
        if (this.getNextPageMarker() != null) {
            sb.append("NextPageMarker: " + this.getNextPageMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResult)) {
            return false;
        }
        ListDomainsResult other = (ListDomainsResult)obj;
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !other.getDomains().equals(this.getDomains())) {
            return false;
        }
        if (other.getNextPageMarker() == null ^ this.getNextPageMarker() == null) {
            return false;
        }
        return other.getNextPageMarker() == null || other.getNextPageMarker().equals(this.getNextPageMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageMarker() == null ? 0 : this.getNextPageMarker().hashCode());
        return hashCode;
    }

    public ListDomainsResult clone() {
        try {
            return (ListDomainsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

