/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CopyOptionGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceOptionGroupIdentifier;
    private String targetOptionGroupIdentifier;
    private String targetOptionGroupDescription;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getSourceOptionGroupIdentifier() {
        return this.sourceOptionGroupIdentifier;
    }

    public void setSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
        this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
    }

    public CopyOptionGroupRequest withSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
        this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
        return this;
    }

    public String getTargetOptionGroupIdentifier() {
        return this.targetOptionGroupIdentifier;
    }

    public void setTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
        this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
    }

    public CopyOptionGroupRequest withTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
        this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
        return this;
    }

    public String getTargetOptionGroupDescription() {
        return this.targetOptionGroupDescription;
    }

    public void setTargetOptionGroupDescription(String targetOptionGroupDescription) {
        this.targetOptionGroupDescription = targetOptionGroupDescription;
    }

    public CopyOptionGroupRequest withTargetOptionGroupDescription(String targetOptionGroupDescription) {
        this.targetOptionGroupDescription = targetOptionGroupDescription;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CopyOptionGroupRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CopyOptionGroupRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceOptionGroupIdentifier() != null) {
            sb.append("SourceOptionGroupIdentifier: " + this.getSourceOptionGroupIdentifier() + ",");
        }
        if (this.getTargetOptionGroupIdentifier() != null) {
            sb.append("TargetOptionGroupIdentifier: " + this.getTargetOptionGroupIdentifier() + ",");
        }
        if (this.getTargetOptionGroupDescription() != null) {
            sb.append("TargetOptionGroupDescription: " + this.getTargetOptionGroupDescription() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceOptionGroupIdentifier() == null ? 0 : this.getSourceOptionGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOptionGroupIdentifier() == null ? 0 : this.getTargetOptionGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOptionGroupDescription() == null ? 0 : this.getTargetOptionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyOptionGroupRequest)) {
            return false;
        }
        CopyOptionGroupRequest other = (CopyOptionGroupRequest)obj;
        if (other.getSourceOptionGroupIdentifier() == null ^ this.getSourceOptionGroupIdentifier() == null) {
            return false;
        }
        if (other.getSourceOptionGroupIdentifier() != null && !other.getSourceOptionGroupIdentifier().equals(this.getSourceOptionGroupIdentifier())) {
            return false;
        }
        if (other.getTargetOptionGroupIdentifier() == null ^ this.getTargetOptionGroupIdentifier() == null) {
            return false;
        }
        if (other.getTargetOptionGroupIdentifier() != null && !other.getTargetOptionGroupIdentifier().equals(this.getTargetOptionGroupIdentifier())) {
            return false;
        }
        if (other.getTargetOptionGroupDescription() == null ^ this.getTargetOptionGroupDescription() == null) {
            return false;
        }
        if (other.getTargetOptionGroupDescription() != null && !other.getTargetOptionGroupDescription().equals(this.getTargetOptionGroupDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    @Override
    public CopyOptionGroupRequest clone() {
        return (CopyOptionGroupRequest)super.clone();
    }
}

