/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.transform.RedshiftDataSpecJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDataSourceFromRedshiftRequestMarshaller
implements Marshaller<Request<CreateDataSourceFromRedshiftRequest>, CreateDataSourceFromRedshiftRequest> {
    @Override
    public Request<CreateDataSourceFromRedshiftRequest> marshall(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        if (createDataSourceFromRedshiftRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDataSourceFromRedshiftRequest> request = new DefaultRequest<CreateDataSourceFromRedshiftRequest>(createDataSourceFromRedshiftRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateDataSourceFromRedshift");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDataSourceFromRedshiftRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value(createDataSourceFromRedshiftRequest.getDataSourceId());
            }
            if (createDataSourceFromRedshiftRequest.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value(createDataSourceFromRedshiftRequest.getDataSourceName());
            }
            if (createDataSourceFromRedshiftRequest.getDataSpec() != null) {
                jsonWriter.key("DataSpec");
                RedshiftDataSpecJsonMarshaller.getInstance().marshall(createDataSourceFromRedshiftRequest.getDataSpec(), jsonWriter);
            }
            if (createDataSourceFromRedshiftRequest.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(createDataSourceFromRedshiftRequest.getRoleARN());
            }
            if (createDataSourceFromRedshiftRequest.getComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value(createDataSourceFromRedshiftRequest.getComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

