/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class DescribeRepositoriesRequestMarshaller
implements Marshaller<Request<DescribeRepositoriesRequest>, DescribeRepositoriesRequest> {
    @Override
    public Request<DescribeRepositoriesRequest> marshall(DescribeRepositoriesRequest describeRepositoriesRequest) {
        if (describeRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRepositoriesRequest> request = new DefaultRequest<DescribeRepositoriesRequest>(describeRepositoriesRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.DescribeRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> repositoryNamesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeRepositoriesRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(describeRepositoriesRequest.getRegistryId());
            }
            if ((repositoryNamesList = describeRepositoriesRequest.getRepositoryNames()) != null) {
                jsonWriter.key("repositoryNames");
                jsonWriter.array();
                for (String repositoryNamesListValue : repositoryNamesList) {
                    if (repositoryNamesListValue == null) continue;
                    jsonWriter.value(repositoryNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (describeRepositoriesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(describeRepositoriesRequest.getNextToken());
            }
            if (describeRepositoriesRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(describeRepositoriesRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

