/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Record;
import com.amazonaws.services.dynamodbv2.model.transform.StreamRecordJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    public void marshall(Record record, JSONWriter jsonWriter) {
        if (record == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (record.getEventID() != null) {
                jsonWriter.key("eventID").value(record.getEventID());
            }
            if (record.getEventName() != null) {
                jsonWriter.key("eventName").value(record.getEventName());
            }
            if (record.getEventVersion() != null) {
                jsonWriter.key("eventVersion").value(record.getEventVersion());
            }
            if (record.getEventSource() != null) {
                jsonWriter.key("eventSource").value(record.getEventSource());
            }
            if (record.getAwsRegion() != null) {
                jsonWriter.key("awsRegion").value(record.getAwsRegion());
            }
            if (record.getDynamodb() != null) {
                jsonWriter.key("dynamodb");
                StreamRecordJsonMarshaller.getInstance().marshall(record.getDynamodb(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

