/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codecommit.model.Commit;
import com.amazonaws.services.codecommit.model.transform.UserInfoJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class CommitJsonMarshaller {
    private static CommitJsonMarshaller instance;

    public void marshall(Commit commit, JSONWriter jsonWriter) {
        if (commit == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> parentsList;
            jsonWriter.object();
            if (commit.getTreeId() != null) {
                jsonWriter.key("treeId").value(commit.getTreeId());
            }
            if ((parentsList = commit.getParents()) != null) {
                jsonWriter.key("parents");
                jsonWriter.array();
                for (String parentsListValue : parentsList) {
                    if (parentsListValue == null) continue;
                    jsonWriter.value(parentsListValue);
                }
                jsonWriter.endArray();
            }
            if (commit.getMessage() != null) {
                jsonWriter.key("message").value(commit.getMessage());
            }
            if (commit.getAuthor() != null) {
                jsonWriter.key("author");
                UserInfoJsonMarshaller.getInstance().marshall(commit.getAuthor(), jsonWriter);
            }
            if (commit.getCommitter() != null) {
                jsonWriter.key("committer");
                UserInfoJsonMarshaller.getInstance().marshall(commit.getCommitter(), jsonWriter);
            }
            if (commit.getAdditionalData() != null) {
                jsonWriter.key("additionalData").value(commit.getAdditionalData());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommitJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommitJsonMarshaller();
        }
        return instance;
    }
}

