/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.codecommit.AWSCodeCommit;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesResult;
import com.amazonaws.services.codecommit.model.BranchDoesNotExistException;
import com.amazonaws.services.codecommit.model.BranchNameExistsException;
import com.amazonaws.services.codecommit.model.BranchNameRequiredException;
import com.amazonaws.services.codecommit.model.CommitDoesNotExistException;
import com.amazonaws.services.codecommit.model.CommitIdDoesNotExistException;
import com.amazonaws.services.codecommit.model.CommitIdRequiredException;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryResult;
import com.amazonaws.services.codecommit.model.DeleteRepositoryRequest;
import com.amazonaws.services.codecommit.model.DeleteRepositoryResult;
import com.amazonaws.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import com.amazonaws.services.codecommit.model.EncryptionKeyAccessDeniedException;
import com.amazonaws.services.codecommit.model.EncryptionKeyDisabledException;
import com.amazonaws.services.codecommit.model.EncryptionKeyNotFoundException;
import com.amazonaws.services.codecommit.model.EncryptionKeyUnavailableException;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.services.codecommit.model.GetBranchResult;
import com.amazonaws.services.codecommit.model.GetCommitRequest;
import com.amazonaws.services.codecommit.model.GetCommitResult;
import com.amazonaws.services.codecommit.model.GetRepositoryRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryResult;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.InvalidBranchNameException;
import com.amazonaws.services.codecommit.model.InvalidCommitIdException;
import com.amazonaws.services.codecommit.model.InvalidContinuationTokenException;
import com.amazonaws.services.codecommit.model.InvalidOrderException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryDescriptionException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerNameException;
import com.amazonaws.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import com.amazonaws.services.codecommit.model.InvalidSortByException;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.services.codecommit.model.ListBranchesResult;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.services.codecommit.model.ListRepositoriesResult;
import com.amazonaws.services.codecommit.model.MaximumBranchesExceededException;
import com.amazonaws.services.codecommit.model.MaximumRepositoryNamesExceededException;
import com.amazonaws.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.RepositoryDoesNotExistException;
import com.amazonaws.services.codecommit.model.RepositoryLimitExceededException;
import com.amazonaws.services.codecommit.model.RepositoryNameExistsException;
import com.amazonaws.services.codecommit.model.RepositoryNameRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryNamesRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggerNameRequiredException;
import com.amazonaws.services.codecommit.model.RepositoryTriggersListRequiredException;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.services.codecommit.model.transform.BatchGetRepositoriesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.BatchGetRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.DeleteRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetBranchResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetCommitRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetCommitResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.GetRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.ListBranchesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.ListBranchesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.ListRepositoriesRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.ListRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.PutRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.PutRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.TestRepositoryTriggersRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.TestRepositoryTriggersResultJsonUnmarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateDefaultBranchRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryDescriptionRequestMarshaller;
import com.amazonaws.services.codecommit.model.transform.UpdateRepositoryNameRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodeCommitClient
extends AmazonWebServiceClient
implements AWSCodeCommit {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeCommit.class);
    private static final String DEFAULT_SIGNING_NAME = "codecommit";
    private static final String DEFAULT_ENDPOINT_PREFIX = "codecommit";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSCodeCommitClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCodeCommitClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCodeCommitClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCodeCommitClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCodeCommitClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaximumBranchesExceededException.class, "MaximumBranchesExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EncryptionKeyNotFoundException.class, "EncryptionKeyNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryNameException.class, "InvalidRepositoryNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidSortByException.class, "InvalidSortByException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerDestinationArnException.class, "InvalidRepositoryTriggerDestinationArnException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EncryptionKeyDisabledException.class, "EncryptionKeyDisabledException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryDescriptionException.class, "InvalidRepositoryDescriptionException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerNameException.class, "InvalidRepositoryTriggerNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerRegionException.class, "InvalidRepositoryTriggerRegionException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(BranchNameRequiredException.class, "BranchNameRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EncryptionKeyAccessDeniedException.class, "EncryptionKeyAccessDeniedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerBranchNameException.class, "InvalidRepositoryTriggerBranchNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryNameExistsException.class, "RepositoryNameExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryTriggerDestinationArnRequiredException.class, "RepositoryTriggerDestinationArnRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryLimitExceededException.class, "RepositoryLimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidOrderException.class, "InvalidOrderException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCommitIdException.class, "InvalidCommitIdException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryNameRequiredException.class, "RepositoryNameRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EncryptionKeyUnavailableException.class, "EncryptionKeyUnavailableException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryTriggerNameRequiredException.class, "RepositoryTriggerNameRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(BranchDoesNotExistException.class, "BranchDoesNotExistException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryTriggersListRequiredException.class, "RepositoryTriggersListRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerEventsException.class, "InvalidRepositoryTriggerEventsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryDoesNotExistException.class, "RepositoryDoesNotExistException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(BranchNameExistsException.class, "BranchNameExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryTriggerEventsListRequiredException.class, "RepositoryTriggerEventsListRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidContinuationTokenException.class, "InvalidContinuationTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EncryptionIntegrityChecksFailedException.class, "EncryptionIntegrityChecksFailedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaximumRepositoryTriggersExceededException.class, "MaximumRepositoryTriggersExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CommitIdDoesNotExistException.class, "CommitIdDoesNotExistException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryNamesRequiredException.class, "RepositoryNamesRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CommitDoesNotExistException.class, "CommitDoesNotExistException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRepositoryTriggerCustomDataException.class, "InvalidRepositoryTriggerCustomDataException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaximumRepositoryNamesExceededException.class, "MaximumRepositoryNamesExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CommitIdRequiredException.class, "CommitIdRequiredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidBranchNameException.class, "InvalidBranchNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryTriggerBranchNameListRequiredException.class, "RepositoryTriggerBranchNameListRequiredException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("codecommit");
        this.setEndpointPrefix("codecommit");
        this.setEndpoint("https://codecommit.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codecommit/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codecommit/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetRepositoriesResult batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetRepositoriesRequestMarshaller().marshall(super.beforeMarshalling(batchGetRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<BatchGetRepositoriesResult> responseHandler = new JsonResponseHandler<BatchGetRepositoriesResult>(new BatchGetRepositoriesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetRepositoriesResult batchGetRepositoriesResult = (BatchGetRepositoriesResult)response.getAwsResponse();
            return batchGetRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createBranch(CreateBranchRequest createBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBranchRequest> request = null;
        Response<?> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBranchRequestMarshaller().marshall(super.beforeMarshalling(createBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestMarshaller().marshall(super.beforeMarshalling(createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateRepositoryResult> responseHandler = new JsonResponseHandler<CreateRepositoryResult>(new CreateRepositoryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestMarshaller().marshall(super.beforeMarshalling(deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteRepositoryResult> responseHandler = new JsonResponseHandler<DeleteRepositoryResult>(new DeleteRepositoryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBranchResult getBranch(GetBranchRequest getBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBranchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBranchRequestMarshaller().marshall(super.beforeMarshalling(getBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetBranchResult> responseHandler = new JsonResponseHandler<GetBranchResult>(new GetBranchResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetBranchResult getBranchResult = (GetBranchResult)response.getAwsResponse();
            return getBranchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCommitResult getCommit(GetCommitRequest getCommitRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCommitRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCommitRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCommitRequestMarshaller().marshall(super.beforeMarshalling(getCommitRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetCommitResult> responseHandler = new JsonResponseHandler<GetCommitResult>(new GetCommitResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetCommitResult getCommitResult = (GetCommitResult)response.getAwsResponse();
            return getCommitResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryResult getRepository(GetRepositoryRequest getRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryRequestMarshaller().marshall(super.beforeMarshalling(getRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetRepositoryResult> responseHandler = new JsonResponseHandler<GetRepositoryResult>(new GetRepositoryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryResult getRepositoryResult = (GetRepositoryResult)response.getAwsResponse();
            return getRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryTriggersResult getRepositoryTriggers(GetRepositoryTriggersRequest getRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryTriggersRequestMarshaller().marshall(super.beforeMarshalling(getRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetRepositoryTriggersResult> responseHandler = new JsonResponseHandler<GetRepositoryTriggersResult>(new GetRepositoryTriggersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryTriggersResult getRepositoryTriggersResult = (GetRepositoryTriggersResult)response.getAwsResponse();
            return getRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBranchesResult listBranches(ListBranchesRequest listBranchesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBranchesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBranchesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBranchesRequestMarshaller().marshall(super.beforeMarshalling(listBranchesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListBranchesResult> responseHandler = new JsonResponseHandler<ListBranchesResult>(new ListBranchesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListBranchesResult listBranchesResult = (ListBranchesResult)response.getAwsResponse();
            return listBranchesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRepositoriesResult listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRepositoriesRequestMarshaller().marshall(super.beforeMarshalling(listRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListRepositoriesResult> responseHandler = new JsonResponseHandler<ListRepositoriesResult>(new ListRepositoriesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListRepositoriesResult listRepositoriesResult = (ListRepositoriesResult)response.getAwsResponse();
            return listRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRepositoryTriggersResult putRepositoryTriggers(PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRepositoryTriggersRequestMarshaller().marshall(super.beforeMarshalling(putRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<PutRepositoryTriggersResult> responseHandler = new JsonResponseHandler<PutRepositoryTriggersResult>(new PutRepositoryTriggersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            PutRepositoryTriggersResult putRepositoryTriggersResult = (PutRepositoryTriggersResult)response.getAwsResponse();
            return putRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRepositoryTriggersResult testRepositoryTriggers(TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testRepositoryTriggersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestRepositoryTriggersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestRepositoryTriggersRequestMarshaller().marshall(super.beforeMarshalling(testRepositoryTriggersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<TestRepositoryTriggersResult> responseHandler = new JsonResponseHandler<TestRepositoryTriggersResult>(new TestRepositoryTriggersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            TestRepositoryTriggersResult testRepositoryTriggersResult = (TestRepositoryTriggersResult)response.getAwsResponse();
            return testRepositoryTriggersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDefaultBranch(UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDefaultBranchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDefaultBranchRequest> request = null;
        Response<?> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDefaultBranchRequestMarshaller().marshall(super.beforeMarshalling(updateDefaultBranchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRepositoryDescription(UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRepositoryDescriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRepositoryDescriptionRequest> request = null;
        Response<?> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRepositoryDescriptionRequestMarshaller().marshall(super.beforeMarshalling(updateRepositoryDescriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRepositoryName(UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRepositoryNameRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRepositoryNameRequest> request = null;
        Response<?> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRepositoryNameRequestMarshaller().marshall(super.beforeMarshalling(updateRepositoryNameRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

