/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateStageRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class UpdateStageRequestMarshaller
implements Marshaller<Request<UpdateStageRequest>, UpdateStageRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateStageRequest> marshall(UpdateStageRequest updateStageRequest) {
        if (updateStageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateStageRequest> request = new DefaultRequest<UpdateStageRequest>(updateStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", updateStageRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateStageRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{stage_name}", updateStageRequest.getStageName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateStageRequest.getStageName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<PatchOperation> patchOperationsList = updateStageRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonWriter.key("patchOperations");
                jsonWriter.array();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

