/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateBasePathMappingRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class UpdateBasePathMappingRequestMarshaller
implements Marshaller<Request<UpdateBasePathMappingRequest>, UpdateBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateBasePathMappingRequest> marshall(UpdateBasePathMappingRequest updateBasePathMappingRequest) {
        if (updateBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateBasePathMappingRequest> request = new DefaultRequest<UpdateBasePathMappingRequest>(updateBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", updateBasePathMappingRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateBasePathMappingRequest.getDomainName()));
        uriResourcePath = uriResourcePath.replace("{base_path}", updateBasePathMappingRequest.getBasePath() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateBasePathMappingRequest.getBasePath()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<PatchOperation> patchOperationsList = updateBasePathMappingRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonWriter.key("patchOperations");
                jsonWriter.array();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

