/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.IPSet;
import com.amazonaws.services.waf.model.IPSetDescriptor;
import com.amazonaws.services.waf.model.transform.IPSetDescriptorJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class IPSetJsonMarshaller {
    private static IPSetJsonMarshaller instance;

    public void marshall(IPSet iPSet, JSONWriter jsonWriter) {
        if (iPSet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<IPSetDescriptor> iPSetDescriptorsList;
            jsonWriter.object();
            if (iPSet.getIPSetId() != null) {
                jsonWriter.key("IPSetId").value(iPSet.getIPSetId());
            }
            if (iPSet.getName() != null) {
                jsonWriter.key("Name").value(iPSet.getName());
            }
            if ((iPSetDescriptorsList = iPSet.getIPSetDescriptors()) != null) {
                jsonWriter.key("IPSetDescriptors");
                jsonWriter.array();
                for (IPSetDescriptor iPSetDescriptorsListValue : iPSetDescriptorsList) {
                    if (iPSetDescriptorsListValue == null) continue;
                    IPSetDescriptorJsonMarshaller.getInstance().marshall(iPSetDescriptorsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IPSetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IPSetJsonMarshaller();
        }
        return instance;
    }
}

