/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.services.simplesystemsmanagement.model.AssociationStatus;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssociationDescription
implements Serializable,
Cloneable {
    private String name;
    private String instanceId;
    private Date dateValue;
    private AssociationStatus status;
    private Map<String, List<String>> parameters;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssociationDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public AssociationDescription withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setDate(Date dateValue) {
        this.dateValue = dateValue;
    }

    public Date getDate() {
        return this.dateValue;
    }

    public AssociationDescription withDate(Date dateValue) {
        this.setDate(dateValue);
        return this;
    }

    public void setStatus(AssociationStatus status) {
        this.status = status;
    }

    public AssociationStatus getStatus() {
        return this.status;
    }

    public AssociationDescription withStatus(AssociationStatus status) {
        this.setStatus(status);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public AssociationDescription withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public AssociationDescription addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public AssociationDescription clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getDate() != null) {
            sb.append("Date: " + this.getDate() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationDescription)) {
            return false;
        }
        AssociationDescription other = (AssociationDescription)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getDate() == null ^ this.getDate() == null) {
            return false;
        }
        if (other.getDate() != null && !other.getDate().equals(this.getDate())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getDate() == null ? 0 : this.getDate().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public AssociationDescription clone() {
        try {
            return (AssociationDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

