/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.GrantListEntry;
import com.amazonaws.services.kms.model.transform.GrantConstraintsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class GrantListEntryJsonMarshaller {
    private static GrantListEntryJsonMarshaller instance;

    public void marshall(GrantListEntry grantListEntry, JSONWriter jsonWriter) {
        if (grantListEntry == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList operationsList;
            jsonWriter.object();
            if (grantListEntry.getKeyId() != null) {
                jsonWriter.key("KeyId").value(grantListEntry.getKeyId());
            }
            if (grantListEntry.getGrantId() != null) {
                jsonWriter.key("GrantId").value(grantListEntry.getGrantId());
            }
            if (grantListEntry.getName() != null) {
                jsonWriter.key("Name").value(grantListEntry.getName());
            }
            if (grantListEntry.getCreationDate() != null) {
                jsonWriter.key("CreationDate").value(grantListEntry.getCreationDate());
            }
            if (grantListEntry.getGranteePrincipal() != null) {
                jsonWriter.key("GranteePrincipal").value(grantListEntry.getGranteePrincipal());
            }
            if (grantListEntry.getRetiringPrincipal() != null) {
                jsonWriter.key("RetiringPrincipal").value(grantListEntry.getRetiringPrincipal());
            }
            if (grantListEntry.getIssuingAccount() != null) {
                jsonWriter.key("IssuingAccount").value(grantListEntry.getIssuingAccount());
            }
            if (!(operationsList = (SdkInternalList)grantListEntry.getOperations()).isEmpty() || !operationsList.isAutoConstruct()) {
                jsonWriter.key("Operations");
                jsonWriter.array();
                for (String operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonWriter.value(operationsListValue);
                }
                jsonWriter.endArray();
            }
            if (grantListEntry.getConstraints() != null) {
                jsonWriter.key("Constraints");
                GrantConstraintsJsonMarshaller.getInstance().marshall(grantListEntry.getConstraints(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GrantListEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GrantListEntryJsonMarshaller();
        }
        return instance;
    }
}

