/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListAliasesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListAliasesRequestMarshaller
implements Marshaller<Request<ListAliasesRequest>, ListAliasesRequest> {
    @Override
    public Request<ListAliasesRequest> marshall(ListAliasesRequest listAliasesRequest) {
        if (listAliasesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAliasesRequest> request = new DefaultRequest<ListAliasesRequest>(listAliasesRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListAliases");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listAliasesRequest.getRoutingStrategyType() != null) {
                jsonWriter.key("RoutingStrategyType").value(listAliasesRequest.getRoutingStrategyType());
            }
            if (listAliasesRequest.getName() != null) {
                jsonWriter.key("Name").value(listAliasesRequest.getName());
            }
            if (listAliasesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listAliasesRequest.getLimit());
            }
            if (listAliasesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listAliasesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

