/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.PlacementTypeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobFlowInstancesConfigJsonMarshaller {
    private static JobFlowInstancesConfigJsonMarshaller instance;

    public void marshall(JobFlowInstancesConfig jobFlowInstancesConfig, JSONWriter jsonWriter) {
        if (jobFlowInstancesConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList additionalSlaveSecurityGroupsList;
            SdkInternalList additionalMasterSecurityGroupsList;
            SdkInternalList instanceGroupsList;
            jsonWriter.object();
            if (jobFlowInstancesConfig.getMasterInstanceType() != null) {
                jsonWriter.key("MasterInstanceType").value(jobFlowInstancesConfig.getMasterInstanceType());
            }
            if (jobFlowInstancesConfig.getSlaveInstanceType() != null) {
                jsonWriter.key("SlaveInstanceType").value(jobFlowInstancesConfig.getSlaveInstanceType());
            }
            if (jobFlowInstancesConfig.getInstanceCount() != null) {
                jsonWriter.key("InstanceCount").value(jobFlowInstancesConfig.getInstanceCount());
            }
            if (!(instanceGroupsList = (SdkInternalList)jobFlowInstancesConfig.getInstanceGroups()).isEmpty() || !instanceGroupsList.isAutoConstruct()) {
                jsonWriter.key("InstanceGroups");
                jsonWriter.array();
                for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
                    if (instanceGroupsListValue == null) continue;
                    InstanceGroupConfigJsonMarshaller.getInstance().marshall(instanceGroupsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (jobFlowInstancesConfig.getEc2KeyName() != null) {
                jsonWriter.key("Ec2KeyName").value(jobFlowInstancesConfig.getEc2KeyName());
            }
            if (jobFlowInstancesConfig.getPlacement() != null) {
                jsonWriter.key("Placement");
                PlacementTypeJsonMarshaller.getInstance().marshall(jobFlowInstancesConfig.getPlacement(), jsonWriter);
            }
            if (jobFlowInstancesConfig.getKeepJobFlowAliveWhenNoSteps() != null) {
                jsonWriter.key("KeepJobFlowAliveWhenNoSteps").value(jobFlowInstancesConfig.getKeepJobFlowAliveWhenNoSteps());
            }
            if (jobFlowInstancesConfig.getTerminationProtected() != null) {
                jsonWriter.key("TerminationProtected").value(jobFlowInstancesConfig.getTerminationProtected());
            }
            if (jobFlowInstancesConfig.getHadoopVersion() != null) {
                jsonWriter.key("HadoopVersion").value(jobFlowInstancesConfig.getHadoopVersion());
            }
            if (jobFlowInstancesConfig.getEc2SubnetId() != null) {
                jsonWriter.key("Ec2SubnetId").value(jobFlowInstancesConfig.getEc2SubnetId());
            }
            if (jobFlowInstancesConfig.getEmrManagedMasterSecurityGroup() != null) {
                jsonWriter.key("EmrManagedMasterSecurityGroup").value(jobFlowInstancesConfig.getEmrManagedMasterSecurityGroup());
            }
            if (jobFlowInstancesConfig.getEmrManagedSlaveSecurityGroup() != null) {
                jsonWriter.key("EmrManagedSlaveSecurityGroup").value(jobFlowInstancesConfig.getEmrManagedSlaveSecurityGroup());
            }
            if (jobFlowInstancesConfig.getServiceAccessSecurityGroup() != null) {
                jsonWriter.key("ServiceAccessSecurityGroup").value(jobFlowInstancesConfig.getServiceAccessSecurityGroup());
            }
            if (!(additionalMasterSecurityGroupsList = (SdkInternalList)jobFlowInstancesConfig.getAdditionalMasterSecurityGroups()).isEmpty() || !additionalMasterSecurityGroupsList.isAutoConstruct()) {
                jsonWriter.key("AdditionalMasterSecurityGroups");
                jsonWriter.array();
                for (String additionalMasterSecurityGroupsListValue : additionalMasterSecurityGroupsList) {
                    if (additionalMasterSecurityGroupsListValue == null) continue;
                    jsonWriter.value(additionalMasterSecurityGroupsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(additionalSlaveSecurityGroupsList = (SdkInternalList)jobFlowInstancesConfig.getAdditionalSlaveSecurityGroups()).isEmpty() || !additionalSlaveSecurityGroupsList.isAutoConstruct()) {
                jsonWriter.key("AdditionalSlaveSecurityGroups");
                jsonWriter.array();
                for (String additionalSlaveSecurityGroupsListValue : additionalSlaveSecurityGroupsList) {
                    if (additionalSlaveSecurityGroupsListValue == null) continue;
                    jsonWriter.value(additionalSlaveSecurityGroupsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobFlowInstancesConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobFlowInstancesConfigJsonMarshaller();
        }
        return instance;
    }
}

