/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class SetRepositoryPolicyRequestMarshaller
implements Marshaller<Request<SetRepositoryPolicyRequest>, SetRepositoryPolicyRequest> {
    @Override
    public Request<SetRepositoryPolicyRequest> marshall(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        if (setRepositoryPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetRepositoryPolicyRequest> request = new DefaultRequest<SetRepositoryPolicyRequest>(setRepositoryPolicyRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.SetRepositoryPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (setRepositoryPolicyRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(setRepositoryPolicyRequest.getRegistryId());
            }
            if (setRepositoryPolicyRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(setRepositoryPolicyRequest.getRepositoryName());
            }
            if (setRepositoryPolicyRequest.getPolicyText() != null) {
                jsonWriter.key("policyText").value(setRepositoryPolicyRequest.getPolicyText());
            }
            if (setRepositoryPolicyRequest.getForce() != null) {
                jsonWriter.key("force").value(setRepositoryPolicyRequest.getForce());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

