/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.Image;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ImageJsonMarshaller {
    private static ImageJsonMarshaller instance;

    public void marshall(Image image, JSONWriter jsonWriter) {
        if (image == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (image.getRegistryId() != null) {
                jsonWriter.key("registryId").value(image.getRegistryId());
            }
            if (image.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(image.getRepositoryName());
            }
            if (image.getImageId() != null) {
                jsonWriter.key("imageId");
                ImageIdentifierJsonMarshaller.getInstance().marshall(image.getImageId(), jsonWriter);
            }
            if (image.getImageManifest() != null) {
                jsonWriter.key("imageManifest").value(image.getImageManifest());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageJsonMarshaller();
        }
        return instance;
    }
}

