/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchdomain.model.SuggestModel;
import com.amazonaws.services.cloudsearchdomain.model.SuggestionMatch;
import com.amazonaws.services.cloudsearchdomain.model.transform.SuggestionMatchJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class SuggestModelJsonMarshaller {
    private static SuggestModelJsonMarshaller instance;

    public void marshall(SuggestModel suggestModel, JSONWriter jsonWriter) {
        if (suggestModel == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList suggestionsList;
            jsonWriter.object();
            if (suggestModel.getQuery() != null) {
                jsonWriter.key("query").value(suggestModel.getQuery());
            }
            if (suggestModel.getFound() != null) {
                jsonWriter.key("found").value(suggestModel.getFound());
            }
            if (!(suggestionsList = (SdkInternalList)suggestModel.getSuggestions()).isEmpty() || !suggestionsList.isAutoConstruct()) {
                jsonWriter.key("suggestions");
                jsonWriter.array();
                for (SuggestionMatch suggestionsListValue : suggestionsList) {
                    if (suggestionsListValue == null) continue;
                    SuggestionMatchJsonMarshaller.getInstance().marshall(suggestionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SuggestModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SuggestModelJsonMarshaller();
        }
        return instance;
    }
}

