/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.GetPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetPolicyRequestMarshaller
implements Marshaller<Request<GetPolicyRequest>, GetPolicyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetPolicyRequest> marshall(GetPolicyRequest getPolicyRequest) {
        if (getPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPolicyRequest> request = new DefaultRequest<GetPolicyRequest>(getPolicyRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies/{policyName}";
        uriResourcePath = uriResourcePath.replace("{policyName}", getPolicyRequest.getPolicyName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getPolicyRequest.getPolicyName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

