/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateLoginProfileRequestMarshaller
implements Marshaller<Request<CreateLoginProfileRequest>, CreateLoginProfileRequest> {
    @Override
    public Request<CreateLoginProfileRequest> marshall(CreateLoginProfileRequest createLoginProfileRequest) {
        if (createLoginProfileRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLoginProfileRequest> request = new DefaultRequest<CreateLoginProfileRequest>(createLoginProfileRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateLoginProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoginProfileRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createLoginProfileRequest.getUserName()));
        }
        if (createLoginProfileRequest.getPassword() != null) {
            request.addParameter("Password", StringUtils.fromString(createLoginProfileRequest.getPassword()));
        }
        if (createLoginProfileRequest.getPasswordResetRequired() != null) {
            request.addParameter("PasswordResetRequired", StringUtils.fromBoolean(createLoginProfileRequest.getPasswordResetRequired()));
        }
        return request;
    }
}

