/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class DescribeFleetAttributesRequestMarshaller
implements Marshaller<Request<DescribeFleetAttributesRequest>, DescribeFleetAttributesRequest> {
    @Override
    public Request<DescribeFleetAttributesRequest> marshall(DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        if (describeFleetAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetAttributesRequest> request = new DefaultRequest<DescribeFleetAttributesRequest>(describeFleetAttributesRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> fleetIdsList = describeFleetAttributesRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonWriter.key("FleetIds");
                jsonWriter.array();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonWriter.value(fleetIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeFleetAttributesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeFleetAttributesRequest.getLimit());
            }
            if (describeFleetAttributesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeFleetAttributesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

