/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cognitosync.model.PushSync;
import com.amazonaws.util.json.JSONWriter;

public class PushSyncJsonMarshaller {
    private static PushSyncJsonMarshaller instance;

    public void marshall(PushSync pushSync, JSONWriter jsonWriter) {
        if (pushSync == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList applicationArnsList = (SdkInternalList)pushSync.getApplicationArns();
            if (!applicationArnsList.isEmpty() || !applicationArnsList.isAutoConstruct()) {
                jsonWriter.key("ApplicationArns");
                jsonWriter.array();
                for (String applicationArnsListValue : applicationArnsList) {
                    if (applicationArnsListValue == null) continue;
                    jsonWriter.value(applicationArnsListValue);
                }
                jsonWriter.endArray();
            }
            if (pushSync.getRoleArn() != null) {
                jsonWriter.key("RoleArn").value(pushSync.getRoleArn());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PushSyncJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PushSyncJsonMarshaller();
        }
        return instance;
    }
}

