/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListRulesRequestMarshaller
implements Marshaller<Request<ListRulesRequest>, ListRulesRequest> {
    @Override
    public Request<ListRulesRequest> marshall(ListRulesRequest listRulesRequest) {
        if (listRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRulesRequest> request = new DefaultRequest<ListRulesRequest>(listRulesRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.ListRules");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listRulesRequest.getNamePrefix() != null) {
                jsonWriter.key("NamePrefix").value(listRulesRequest.getNamePrefix());
            }
            if (listRulesRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listRulesRequest.getNextToken());
            }
            if (listRulesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listRulesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

