/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Method;
import com.amazonaws.services.apigateway.model.MethodResponse;
import com.amazonaws.services.apigateway.model.transform.IntegrationJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.MethodResponseJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class MethodJsonMarshaller {
    private static MethodJsonMarshaller instance;

    public void marshall(Method method, JSONWriter jsonWriter) {
        if (method == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, MethodResponse> methodResponsesMap;
            Map<String, String> requestModelsMap;
            Map<String, Boolean> requestParametersMap;
            jsonWriter.object();
            if (method.getHttpMethod() != null) {
                jsonWriter.key("httpMethod").value(method.getHttpMethod());
            }
            if (method.getAuthorizationType() != null) {
                jsonWriter.key("authorizationType").value(method.getAuthorizationType());
            }
            if (method.getAuthorizerId() != null) {
                jsonWriter.key("authorizerId").value(method.getAuthorizerId());
            }
            if (method.getApiKeyRequired() != null) {
                jsonWriter.key("apiKeyRequired").value(method.getApiKeyRequired());
            }
            if ((requestParametersMap = method.getRequestParameters()) != null) {
                jsonWriter.key("requestParameters");
                jsonWriter.object();
                for (Map.Entry<String, Boolean> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(requestParametersMapValue.getKey());
                    jsonWriter.value(requestParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((requestModelsMap = method.getRequestModels()) != null) {
                jsonWriter.key("requestModels");
                jsonWriter.object();
                for (Map.Entry<String, String> requestModelsMapValue : requestModelsMap.entrySet()) {
                    if (requestModelsMapValue.getValue() == null) continue;
                    jsonWriter.key(requestModelsMapValue.getKey());
                    jsonWriter.value(requestModelsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((methodResponsesMap = method.getMethodResponses()) != null) {
                jsonWriter.key("methodResponses");
                jsonWriter.object();
                for (Map.Entry<String, MethodResponse> methodResponsesMapValue : methodResponsesMap.entrySet()) {
                    if (methodResponsesMapValue.getValue() == null) continue;
                    jsonWriter.key(methodResponsesMapValue.getKey());
                    MethodResponseJsonMarshaller.getInstance().marshall(methodResponsesMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (method.getMethodIntegration() != null) {
                jsonWriter.key("methodIntegration");
                IntegrationJsonMarshaller.getInstance().marshall(method.getMethodIntegration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MethodJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MethodJsonMarshaller();
        }
        return instance;
    }
}

