/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class S3DestinationDescriptionJsonMarshaller {
    private static S3DestinationDescriptionJsonMarshaller instance;

    public void marshall(S3DestinationDescription s3DestinationDescription, JSONWriter jsonWriter) {
        if (s3DestinationDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (s3DestinationDescription.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(s3DestinationDescription.getRoleARN());
            }
            if (s3DestinationDescription.getBucketARN() != null) {
                jsonWriter.key("BucketARN").value(s3DestinationDescription.getBucketARN());
            }
            if (s3DestinationDescription.getPrefix() != null) {
                jsonWriter.key("Prefix").value(s3DestinationDescription.getPrefix());
            }
            if (s3DestinationDescription.getBufferingHints() != null) {
                jsonWriter.key("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationDescription.getBufferingHints(), jsonWriter);
            }
            if (s3DestinationDescription.getCompressionFormat() != null) {
                jsonWriter.key("CompressionFormat").value(s3DestinationDescription.getCompressionFormat());
            }
            if (s3DestinationDescription.getEncryptionConfiguration() != null) {
                jsonWriter.key("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationDescription.getEncryptionConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

