/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.Alias;
import com.amazonaws.services.gamelift.model.transform.RoutingStrategyJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class AliasJsonMarshaller {
    private static AliasJsonMarshaller instance;

    public void marshall(Alias alias, JSONWriter jsonWriter) {
        if (alias == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (alias.getAliasId() != null) {
                jsonWriter.key("AliasId").value(alias.getAliasId());
            }
            if (alias.getName() != null) {
                jsonWriter.key("Name").value(alias.getName());
            }
            if (alias.getDescription() != null) {
                jsonWriter.key("Description").value(alias.getDescription());
            }
            if (alias.getRoutingStrategy() != null) {
                jsonWriter.key("RoutingStrategy");
                RoutingStrategyJsonMarshaller.getInstance().marshall(alias.getRoutingStrategy(), jsonWriter);
            }
            if (alias.getCreationTime() != null) {
                jsonWriter.key("CreationTime").value(alias.getCreationTime());
            }
            if (alias.getLastUpdatedTime() != null) {
                jsonWriter.key("LastUpdatedTime").value(alias.getLastUpdatedTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AliasJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AliasJsonMarshaller();
        }
        return instance;
    }
}

