/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.InstanceInfo;
import com.amazonaws.services.codedeploy.model.Tag;
import com.amazonaws.services.codedeploy.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceInfoJsonMarshaller {
    private static InstanceInfoJsonMarshaller instance;

    public void marshall(InstanceInfo instanceInfo, JSONWriter jsonWriter) {
        if (instanceInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList tagsList;
            jsonWriter.object();
            if (instanceInfo.getInstanceName() != null) {
                jsonWriter.key("instanceName").value(instanceInfo.getInstanceName());
            }
            if (instanceInfo.getIamUserArn() != null) {
                jsonWriter.key("iamUserArn").value(instanceInfo.getIamUserArn());
            }
            if (instanceInfo.getInstanceArn() != null) {
                jsonWriter.key("instanceArn").value(instanceInfo.getInstanceArn());
            }
            if (instanceInfo.getRegisterTime() != null) {
                jsonWriter.key("registerTime").value(instanceInfo.getRegisterTime());
            }
            if (instanceInfo.getDeregisterTime() != null) {
                jsonWriter.key("deregisterTime").value(instanceInfo.getDeregisterTime());
            }
            if (!(tagsList = (SdkInternalList)instanceInfo.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonWriter.key("tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceInfoJsonMarshaller();
        }
        return instance;
    }
}

