/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.LocalizedText;
import com.amazonaws.services.inspector.model.Parameter;
import com.amazonaws.services.inspector.model.transform.LocalizedTextKeyJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.ParameterJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class LocalizedTextJsonMarshaller {
    private static LocalizedTextJsonMarshaller instance;

    public void marshall(LocalizedText localizedText, JSONWriter jsonWriter) {
        if (localizedText == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Parameter> parametersList;
            jsonWriter.object();
            if (localizedText.getKey() != null) {
                jsonWriter.key("key");
                LocalizedTextKeyJsonMarshaller.getInstance().marshall(localizedText.getKey(), jsonWriter);
            }
            if ((parametersList = localizedText.getParameters()) != null) {
                jsonWriter.key("parameters");
                jsonWriter.array();
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue == null) continue;
                    ParameterJsonMarshaller.getInstance().marshall(parametersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalizedTextJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalizedTextJsonMarshaller();
        }
        return instance;
    }
}

