/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreateFleetRequest;
import com.amazonaws.services.gamelift.model.IpPermission;
import com.amazonaws.services.gamelift.model.transform.IpPermissionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    @Override
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        if (createFleetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFleetRequest> request = new DefaultRequest<CreateFleetRequest>(createFleetRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateFleet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IpPermission> eC2InboundPermissionsList;
            List<String> logPathsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createFleetRequest.getName() != null) {
                jsonWriter.key("Name").value(createFleetRequest.getName());
            }
            if (createFleetRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createFleetRequest.getDescription());
            }
            if (createFleetRequest.getBuildId() != null) {
                jsonWriter.key("BuildId").value(createFleetRequest.getBuildId());
            }
            if (createFleetRequest.getServerLaunchPath() != null) {
                jsonWriter.key("ServerLaunchPath").value(createFleetRequest.getServerLaunchPath());
            }
            if (createFleetRequest.getServerLaunchParameters() != null) {
                jsonWriter.key("ServerLaunchParameters").value(createFleetRequest.getServerLaunchParameters());
            }
            if ((logPathsList = createFleetRequest.getLogPaths()) != null) {
                jsonWriter.key("LogPaths");
                jsonWriter.array();
                for (String logPathsListValue : logPathsList) {
                    if (logPathsListValue == null) continue;
                    jsonWriter.value(logPathsListValue);
                }
                jsonWriter.endArray();
            }
            if (createFleetRequest.getEC2InstanceType() != null) {
                jsonWriter.key("EC2InstanceType").value(createFleetRequest.getEC2InstanceType());
            }
            if ((eC2InboundPermissionsList = createFleetRequest.getEC2InboundPermissions()) != null) {
                jsonWriter.key("EC2InboundPermissions");
                jsonWriter.array();
                for (IpPermission eC2InboundPermissionsListValue : eC2InboundPermissionsList) {
                    if (eC2InboundPermissionsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(eC2InboundPermissionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

