/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Deployment;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.Service;
import com.amazonaws.services.ecs.model.ServiceEvent;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.DeploymentJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LoadBalancerJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ServiceEventJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ServiceJsonMarshaller {
    private static ServiceJsonMarshaller instance;

    public void marshall(Service service, JSONWriter jsonWriter) {
        if (service == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList eventsList;
            SdkInternalList deploymentsList;
            SdkInternalList loadBalancersList;
            jsonWriter.object();
            if (service.getServiceArn() != null) {
                jsonWriter.key("serviceArn").value(service.getServiceArn());
            }
            if (service.getServiceName() != null) {
                jsonWriter.key("serviceName").value(service.getServiceName());
            }
            if (service.getClusterArn() != null) {
                jsonWriter.key("clusterArn").value(service.getClusterArn());
            }
            if (!(loadBalancersList = (SdkInternalList)service.getLoadBalancers()).isEmpty() || !loadBalancersList.isAutoConstruct()) {
                jsonWriter.key("loadBalancers");
                jsonWriter.array();
                for (LoadBalancer loadBalancersListValue : loadBalancersList) {
                    if (loadBalancersListValue == null) continue;
                    LoadBalancerJsonMarshaller.getInstance().marshall(loadBalancersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (service.getStatus() != null) {
                jsonWriter.key("status").value(service.getStatus());
            }
            if (service.getDesiredCount() != null) {
                jsonWriter.key("desiredCount").value(service.getDesiredCount());
            }
            if (service.getRunningCount() != null) {
                jsonWriter.key("runningCount").value(service.getRunningCount());
            }
            if (service.getPendingCount() != null) {
                jsonWriter.key("pendingCount").value(service.getPendingCount());
            }
            if (service.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value(service.getTaskDefinition());
            }
            if (service.getDeploymentConfiguration() != null) {
                jsonWriter.key("deploymentConfiguration");
                DeploymentConfigurationJsonMarshaller.getInstance().marshall(service.getDeploymentConfiguration(), jsonWriter);
            }
            if (!(deploymentsList = (SdkInternalList)service.getDeployments()).isEmpty() || !deploymentsList.isAutoConstruct()) {
                jsonWriter.key("deployments");
                jsonWriter.array();
                for (Deployment deploymentsListValue : deploymentsList) {
                    if (deploymentsListValue == null) continue;
                    DeploymentJsonMarshaller.getInstance().marshall(deploymentsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (service.getRoleArn() != null) {
                jsonWriter.key("roleArn").value(service.getRoleArn());
            }
            if (!(eventsList = (SdkInternalList)service.getEvents()).isEmpty() || !eventsList.isAutoConstruct()) {
                jsonWriter.key("events");
                jsonWriter.array();
                for (ServiceEvent eventsListValue : eventsList) {
                    if (eventsListValue == null) continue;
                    ServiceEventJsonMarshaller.getInstance().marshall(eventsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceJsonMarshaller();
        }
        return instance;
    }
}

