/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.UpdateThingRequest;
import com.amazonaws.services.iot.model.transform.AttributePayloadJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateThingRequestMarshaller
implements Marshaller<Request<UpdateThingRequest>, UpdateThingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateThingRequest> marshall(UpdateThingRequest updateThingRequest) {
        if (updateThingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateThingRequest> request = new DefaultRequest<UpdateThingRequest>(updateThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", updateThingRequest.getThingName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateThingRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateThingRequest.getAttributePayload() != null) {
                jsonWriter.key("attributePayload");
                AttributePayloadJsonMarshaller.getInstance().marshall(updateThingRequest.getAttributePayload(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

