/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    @Override
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "AmazonSNS");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(publishRequest.getTopicArn()));
        }
        if (publishRequest.getTargetArn() != null) {
            request.addParameter("TargetArn", StringUtils.fromString(publishRequest.getTargetArn()));
        }
        if (publishRequest.getMessage() != null) {
            request.addParameter("Message", StringUtils.fromString(publishRequest.getMessage()));
        }
        if (publishRequest.getSubject() != null) {
            request.addParameter("Subject", StringUtils.fromString(publishRequest.getSubject()));
        }
        if (publishRequest.getMessageStructure() != null) {
            request.addParameter("MessageStructure", StringUtils.fromString(publishRequest.getMessageStructure()));
        }
        Map<String, MessageAttributeValue> messageAttributes = publishRequest.getMessageAttributes();
        int messageAttributesListIndex = 1;
        for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Name", StringUtils.fromString(entry.getKey()));
            }
            if (entry.getValue() != null) {
                if (entry.getValue().getDataType() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString(entry.getValue().getDataType()));
                }
                if (entry.getValue().getStringValue() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString(entry.getValue().getStringValue()));
                }
                if (entry.getValue().getBinaryValue() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer(entry.getValue().getBinaryValue()));
                }
            }
            ++messageAttributesListIndex;
        }
        return request;
    }
}

