/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.ChangePasswordRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ChangePasswordRequestMarshaller
implements Marshaller<Request<ChangePasswordRequest>, ChangePasswordRequest> {
    @Override
    public Request<ChangePasswordRequest> marshall(ChangePasswordRequest changePasswordRequest) {
        if (changePasswordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ChangePasswordRequest> request = new DefaultRequest<ChangePasswordRequest>(changePasswordRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "ChangePassword");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (changePasswordRequest.getOldPassword() != null) {
            request.addParameter("OldPassword", StringUtils.fromString(changePasswordRequest.getOldPassword()));
        }
        if (changePasswordRequest.getNewPassword() != null) {
            request.addParameter("NewPassword", StringUtils.fromString(changePasswordRequest.getNewPassword()));
        }
        return request;
    }
}

