/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.IpPermission;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.transform.IpPermissionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class UpdateFleetPortSettingsRequestMarshaller
implements Marshaller<Request<UpdateFleetPortSettingsRequest>, UpdateFleetPortSettingsRequest> {
    @Override
    public Request<UpdateFleetPortSettingsRequest> marshall(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) {
        if (updateFleetPortSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFleetPortSettingsRequest> request = new DefaultRequest<UpdateFleetPortSettingsRequest>(updateFleetPortSettingsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateFleetPortSettings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IpPermission> inboundPermissionRevocationsList;
            List<IpPermission> inboundPermissionAuthorizationsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateFleetPortSettingsRequest.getFleetId() != null) {
                jsonWriter.key("FleetId").value(updateFleetPortSettingsRequest.getFleetId());
            }
            if ((inboundPermissionAuthorizationsList = updateFleetPortSettingsRequest.getInboundPermissionAuthorizations()) != null) {
                jsonWriter.key("InboundPermissionAuthorizations");
                jsonWriter.array();
                for (IpPermission inboundPermissionAuthorizationsListValue : inboundPermissionAuthorizationsList) {
                    if (inboundPermissionAuthorizationsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(inboundPermissionAuthorizationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((inboundPermissionRevocationsList = updateFleetPortSettingsRequest.getInboundPermissionRevocations()) != null) {
                jsonWriter.key("InboundPermissionRevocations");
                jsonWriter.array();
                for (IpPermission inboundPermissionRevocationsListValue : inboundPermissionRevocationsList) {
                    if (inboundPermissionRevocationsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(inboundPermissionRevocationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

