/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.EC2InstanceType;
import com.amazonaws.services.gamelift.model.IpPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String buildId;
    private String serverLaunchPath;
    private String serverLaunchParameters;
    private List<String> logPaths;
    private String eC2InstanceType;
    private List<IpPermission> eC2InboundPermissions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateFleetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateFleetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public CreateFleetRequest withBuildId(String buildId) {
        this.setBuildId(buildId);
        return this;
    }

    public void setServerLaunchPath(String serverLaunchPath) {
        this.serverLaunchPath = serverLaunchPath;
    }

    public String getServerLaunchPath() {
        return this.serverLaunchPath;
    }

    public CreateFleetRequest withServerLaunchPath(String serverLaunchPath) {
        this.setServerLaunchPath(serverLaunchPath);
        return this;
    }

    public void setServerLaunchParameters(String serverLaunchParameters) {
        this.serverLaunchParameters = serverLaunchParameters;
    }

    public String getServerLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public CreateFleetRequest withServerLaunchParameters(String serverLaunchParameters) {
        this.setServerLaunchParameters(serverLaunchParameters);
        return this;
    }

    public List<String> getLogPaths() {
        return this.logPaths;
    }

    public void setLogPaths(Collection<String> logPaths) {
        if (logPaths == null) {
            this.logPaths = null;
            return;
        }
        this.logPaths = new ArrayList<String>(logPaths);
    }

    public CreateFleetRequest withLogPaths(String ... logPaths) {
        if (this.logPaths == null) {
            this.setLogPaths(new ArrayList<String>(logPaths.length));
        }
        for (String ele : logPaths) {
            this.logPaths.add(ele);
        }
        return this;
    }

    public CreateFleetRequest withLogPaths(Collection<String> logPaths) {
        this.setLogPaths(logPaths);
        return this;
    }

    public void setEC2InstanceType(String eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType;
    }

    public String getEC2InstanceType() {
        return this.eC2InstanceType;
    }

    public CreateFleetRequest withEC2InstanceType(String eC2InstanceType) {
        this.setEC2InstanceType(eC2InstanceType);
        return this;
    }

    public void setEC2InstanceType(EC2InstanceType eC2InstanceType) {
        this.eC2InstanceType = eC2InstanceType.toString();
    }

    public CreateFleetRequest withEC2InstanceType(EC2InstanceType eC2InstanceType) {
        this.setEC2InstanceType(eC2InstanceType);
        return this;
    }

    public List<IpPermission> getEC2InboundPermissions() {
        return this.eC2InboundPermissions;
    }

    public void setEC2InboundPermissions(Collection<IpPermission> eC2InboundPermissions) {
        if (eC2InboundPermissions == null) {
            this.eC2InboundPermissions = null;
            return;
        }
        this.eC2InboundPermissions = new ArrayList<IpPermission>(eC2InboundPermissions);
    }

    public CreateFleetRequest withEC2InboundPermissions(IpPermission ... eC2InboundPermissions) {
        if (this.eC2InboundPermissions == null) {
            this.setEC2InboundPermissions(new ArrayList<IpPermission>(eC2InboundPermissions.length));
        }
        for (IpPermission ele : eC2InboundPermissions) {
            this.eC2InboundPermissions.add(ele);
        }
        return this;
    }

    public CreateFleetRequest withEC2InboundPermissions(Collection<IpPermission> eC2InboundPermissions) {
        this.setEC2InboundPermissions(eC2InboundPermissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getBuildId() != null) {
            sb.append("BuildId: " + this.getBuildId() + ",");
        }
        if (this.getServerLaunchPath() != null) {
            sb.append("ServerLaunchPath: " + this.getServerLaunchPath() + ",");
        }
        if (this.getServerLaunchParameters() != null) {
            sb.append("ServerLaunchParameters: " + this.getServerLaunchParameters() + ",");
        }
        if (this.getLogPaths() != null) {
            sb.append("LogPaths: " + this.getLogPaths() + ",");
        }
        if (this.getEC2InstanceType() != null) {
            sb.append("EC2InstanceType: " + this.getEC2InstanceType() + ",");
        }
        if (this.getEC2InboundPermissions() != null) {
            sb.append("EC2InboundPermissions: " + this.getEC2InboundPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getBuildId() == null ^ this.getBuildId() == null) {
            return false;
        }
        if (other.getBuildId() != null && !other.getBuildId().equals(this.getBuildId())) {
            return false;
        }
        if (other.getServerLaunchPath() == null ^ this.getServerLaunchPath() == null) {
            return false;
        }
        if (other.getServerLaunchPath() != null && !other.getServerLaunchPath().equals(this.getServerLaunchPath())) {
            return false;
        }
        if (other.getServerLaunchParameters() == null ^ this.getServerLaunchParameters() == null) {
            return false;
        }
        if (other.getServerLaunchParameters() != null && !other.getServerLaunchParameters().equals(this.getServerLaunchParameters())) {
            return false;
        }
        if (other.getLogPaths() == null ^ this.getLogPaths() == null) {
            return false;
        }
        if (other.getLogPaths() != null && !other.getLogPaths().equals(this.getLogPaths())) {
            return false;
        }
        if (other.getEC2InstanceType() == null ^ this.getEC2InstanceType() == null) {
            return false;
        }
        if (other.getEC2InstanceType() != null && !other.getEC2InstanceType().equals(this.getEC2InstanceType())) {
            return false;
        }
        if (other.getEC2InboundPermissions() == null ^ this.getEC2InboundPermissions() == null) {
            return false;
        }
        return other.getEC2InboundPermissions() == null || other.getEC2InboundPermissions().equals(this.getEC2InboundPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBuildId() == null ? 0 : this.getBuildId().hashCode());
        hashCode = 31 * hashCode + (this.getServerLaunchPath() == null ? 0 : this.getServerLaunchPath().hashCode());
        hashCode = 31 * hashCode + (this.getServerLaunchParameters() == null ? 0 : this.getServerLaunchParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLogPaths() == null ? 0 : this.getLogPaths().hashCode());
        hashCode = 31 * hashCode + (this.getEC2InstanceType() == null ? 0 : this.getEC2InstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getEC2InboundPermissions() == null ? 0 : this.getEC2InboundPermissions().hashCode());
        return hashCode;
    }

    @Override
    public CreateFleetRequest clone() {
        return (CreateFleetRequest)super.clone();
    }
}

