/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.AudioParameters;
import com.amazonaws.services.elastictranscoder.model.transform.AudioCodecOptionsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class AudioParametersJsonMarshaller {
    private static AudioParametersJsonMarshaller instance;

    public void marshall(AudioParameters audioParameters, JSONWriter jsonWriter) {
        if (audioParameters == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (audioParameters.getCodec() != null) {
                jsonWriter.key("Codec").value(audioParameters.getCodec());
            }
            if (audioParameters.getSampleRate() != null) {
                jsonWriter.key("SampleRate").value(audioParameters.getSampleRate());
            }
            if (audioParameters.getBitRate() != null) {
                jsonWriter.key("BitRate").value(audioParameters.getBitRate());
            }
            if (audioParameters.getChannels() != null) {
                jsonWriter.key("Channels").value(audioParameters.getChannels());
            }
            if (audioParameters.getAudioPackingMode() != null) {
                jsonWriter.key("AudioPackingMode").value(audioParameters.getAudioPackingMode());
            }
            if (audioParameters.getCodecOptions() != null) {
                jsonWriter.key("CodecOptions");
                AudioCodecOptionsJsonMarshaller.getInstance().marshall(audioParameters.getCodecOptions(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AudioParametersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AudioParametersJsonMarshaller();
        }
        return instance;
    }
}

