/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ApplicationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStatusJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.Ec2InstanceAttributesJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ClusterJsonMarshaller {
    private static ClusterJsonMarshaller instance;

    public void marshall(Cluster cluster, JSONWriter jsonWriter) {
        if (cluster == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList configurationsList;
            SdkInternalList tagsList;
            SdkInternalList applicationsList;
            jsonWriter.object();
            if (cluster.getId() != null) {
                jsonWriter.key("Id").value(cluster.getId());
            }
            if (cluster.getName() != null) {
                jsonWriter.key("Name").value(cluster.getName());
            }
            if (cluster.getStatus() != null) {
                jsonWriter.key("Status");
                ClusterStatusJsonMarshaller.getInstance().marshall(cluster.getStatus(), jsonWriter);
            }
            if (cluster.getEc2InstanceAttributes() != null) {
                jsonWriter.key("Ec2InstanceAttributes");
                Ec2InstanceAttributesJsonMarshaller.getInstance().marshall(cluster.getEc2InstanceAttributes(), jsonWriter);
            }
            if (cluster.getLogUri() != null) {
                jsonWriter.key("LogUri").value(cluster.getLogUri());
            }
            if (cluster.getRequestedAmiVersion() != null) {
                jsonWriter.key("RequestedAmiVersion").value(cluster.getRequestedAmiVersion());
            }
            if (cluster.getRunningAmiVersion() != null) {
                jsonWriter.key("RunningAmiVersion").value(cluster.getRunningAmiVersion());
            }
            if (cluster.getReleaseLabel() != null) {
                jsonWriter.key("ReleaseLabel").value(cluster.getReleaseLabel());
            }
            if (cluster.getAutoTerminate() != null) {
                jsonWriter.key("AutoTerminate").value(cluster.getAutoTerminate());
            }
            if (cluster.getTerminationProtected() != null) {
                jsonWriter.key("TerminationProtected").value(cluster.getTerminationProtected());
            }
            if (cluster.getVisibleToAllUsers() != null) {
                jsonWriter.key("VisibleToAllUsers").value(cluster.getVisibleToAllUsers());
            }
            if (!(applicationsList = (SdkInternalList)cluster.getApplications()).isEmpty() || !applicationsList.isAutoConstruct()) {
                jsonWriter.key("Applications");
                jsonWriter.array();
                for (Application applicationsListValue : applicationsList) {
                    if (applicationsListValue == null) continue;
                    ApplicationJsonMarshaller.getInstance().marshall(applicationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(tagsList = (SdkInternalList)cluster.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (cluster.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value(cluster.getServiceRole());
            }
            if (cluster.getNormalizedInstanceHours() != null) {
                jsonWriter.key("NormalizedInstanceHours").value(cluster.getNormalizedInstanceHours());
            }
            if (cluster.getMasterPublicDnsName() != null) {
                jsonWriter.key("MasterPublicDnsName").value(cluster.getMasterPublicDnsName());
            }
            if (!(configurationsList = (SdkInternalList)cluster.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterJsonMarshaller();
        }
        return instance;
    }
}

