/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RebootCacheClusterRequestMarshaller
implements Marshaller<Request<RebootCacheClusterRequest>, RebootCacheClusterRequest> {
    @Override
    public Request<RebootCacheClusterRequest> marshall(RebootCacheClusterRequest rebootCacheClusterRequest) {
        if (rebootCacheClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebootCacheClusterRequest> request = new DefaultRequest<RebootCacheClusterRequest>(rebootCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "RebootCacheCluster");
        request.addParameter("Version", "2015-02-02");
        if (rebootCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(rebootCacheClusterRequest.getCacheClusterId()));
        }
        List<String> cacheNodeIdsToRebootList = rebootCacheClusterRequest.getCacheNodeIdsToReboot();
        int cacheNodeIdsToRebootListIndex = 1;
        for (String cacheNodeIdsToRebootListValue : cacheNodeIdsToRebootList) {
            if (cacheNodeIdsToRebootListValue != null) {
                request.addParameter("CacheNodeIdsToReboot.CacheNodeId." + cacheNodeIdsToRebootListIndex, StringUtils.fromString(cacheNodeIdsToRebootListValue));
            }
            ++cacheNodeIdsToRebootListIndex;
        }
        return request;
    }
}

