/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListDatasetsRequestMarshaller
implements Marshaller<Request<ListDatasetsRequest>, ListDatasetsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    @Override
    public Request<ListDatasetsRequest> marshall(ListDatasetsRequest listDatasetsRequest) {
        String maxResults;
        String nextToken;
        if (listDatasetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDatasetsRequest> request = new DefaultRequest<ListDatasetsRequest>(listDatasetsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listDatasetsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(listDatasetsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listDatasetsRequest.getIdentityId() == null ? "" : StringUtils.fromString(listDatasetsRequest.getIdentityId()));
        request.setResourcePath(uriResourcePath);
        String string = nextToken = listDatasetsRequest.getNextToken() == null ? null : StringUtils.fromString(listDatasetsRequest.getNextToken());
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        String string2 = maxResults = listDatasetsRequest.getMaxResults() == null ? null : StringUtils.fromInteger(listDatasetsRequest.getMaxResults());
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

