/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.PipelineContext;
import com.amazonaws.services.codepipeline.model.transform.ActionContextJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StageContextJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineContextJsonMarshaller {
    private static PipelineContextJsonMarshaller instance;

    public void marshall(PipelineContext pipelineContext, JSONWriter jsonWriter) {
        if (pipelineContext == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (pipelineContext.getPipelineName() != null) {
                jsonWriter.key("pipelineName").value(pipelineContext.getPipelineName());
            }
            if (pipelineContext.getStage() != null) {
                jsonWriter.key("stage");
                StageContextJsonMarshaller.getInstance().marshall(pipelineContext.getStage(), jsonWriter);
            }
            if (pipelineContext.getAction() != null) {
                jsonWriter.key("action");
                ActionContextJsonMarshaller.getInstance().marshall(pipelineContext.getAction(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineContextJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineContextJsonMarshaller();
        }
        return instance;
    }
}

