/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.ListOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListOnPremisesInstancesRequestMarshaller
implements Marshaller<Request<ListOnPremisesInstancesRequest>, ListOnPremisesInstancesRequest> {
    @Override
    public Request<ListOnPremisesInstancesRequest> marshall(ListOnPremisesInstancesRequest listOnPremisesInstancesRequest) {
        if (listOnPremisesInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListOnPremisesInstancesRequest> request = new DefaultRequest<ListOnPremisesInstancesRequest>(listOnPremisesInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListOnPremisesInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagFiltersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listOnPremisesInstancesRequest.getRegistrationStatus() != null) {
                jsonWriter.key("registrationStatus").value(listOnPremisesInstancesRequest.getRegistrationStatus());
            }
            if (!(tagFiltersList = (SdkInternalList)listOnPremisesInstancesRequest.getTagFilters()).isEmpty() || !tagFiltersList.isAutoConstruct()) {
                jsonWriter.key("tagFilters");
                jsonWriter.array();
                for (TagFilter tagFiltersListValue : tagFiltersList) {
                    if (tagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(tagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (listOnPremisesInstancesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listOnPremisesInstancesRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

