/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Resource;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Event
implements Serializable,
Cloneable {
    private String eventId;
    private String eventName;
    private Date eventTime;
    private String username;
    private SdkInternalList<Resource> resources;
    private String cloudTrailEvent;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Event withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Event withEventName(String eventName) {
        this.setEventName(eventName);
        return this;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public Event withEventTime(Date eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public Event withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList<Resource>(resources);
    }

    public Event withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new SdkInternalList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public Event withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public void setCloudTrailEvent(String cloudTrailEvent) {
        this.cloudTrailEvent = cloudTrailEvent;
    }

    public String getCloudTrailEvent() {
        return this.cloudTrailEvent;
    }

    public Event withCloudTrailEvent(String cloudTrailEvent) {
        this.setCloudTrailEvent(cloudTrailEvent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: " + this.getEventId() + ",");
        }
        if (this.getEventName() != null) {
            sb.append("EventName: " + this.getEventName() + ",");
        }
        if (this.getEventTime() != null) {
            sb.append("EventTime: " + this.getEventTime() + ",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: " + this.getResources() + ",");
        }
        if (this.getCloudTrailEvent() != null) {
            sb.append("CloudTrailEvent: " + this.getCloudTrailEvent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventName() == null ^ this.getEventName() == null) {
            return false;
        }
        if (other.getEventName() != null && !other.getEventName().equals(this.getEventName())) {
            return false;
        }
        if (other.getEventTime() == null ^ this.getEventTime() == null) {
            return false;
        }
        if (other.getEventTime() != null && !other.getEventTime().equals(this.getEventTime())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getCloudTrailEvent() == null ^ this.getCloudTrailEvent() == null) {
            return false;
        }
        return other.getCloudTrailEvent() == null || other.getCloudTrailEvent().equals(this.getCloudTrailEvent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventName() == null ? 0 : this.getEventName().hashCode());
        hashCode = 31 * hashCode + (this.getEventTime() == null ? 0 : this.getEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getCloudTrailEvent() == null ? 0 : this.getCloudTrailEvent().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

