/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListWebACLsRequestMarshaller
implements Marshaller<Request<ListWebACLsRequest>, ListWebACLsRequest> {
    @Override
    public Request<ListWebACLsRequest> marshall(ListWebACLsRequest listWebACLsRequest) {
        if (listWebACLsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListWebACLsRequest> request = new DefaultRequest<ListWebACLsRequest>(listWebACLsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.ListWebACLs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listWebACLsRequest.getNextMarker() != null) {
                jsonWriter.key("NextMarker").value(listWebACLsRequest.getNextMarker());
            }
            if (listWebACLsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listWebACLsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

